//------------------------
// PARAMETERS

float4x4 gWorldViewProjMatrix
<
   string paramClass="intrinsic";
   string paramName="worldViewProj";
> = float4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1);

float4x4 gWorldViewMatrix
<
   string paramClass="intrinsic";
   string paramName="worldView";
> = float4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1);

float gRGBScale
<
   string paramClass="intrinsic";
   string paramName="RGBScale";
   string paramType="float";
> = 1.0f;

float gZOffsetScale
<
   string paramClass="param";
   string paramName = "ZScale";
   string paramType ="float";
> = 1.0f;

sampler gSampler0 : register(s0);
sampler gSampler1 : register(s1);

// END PARAMETERS


//------------------------
// SUBROUTINES

vec4 SRGBToLinear(vec4 c)
{
   vec4 ret = c;
   ret.rgb *= ret.rgb;
   return ret;
}

// END SUBROUTINES


//------------------------
// FUNCTION_VS ParticleVS

uniform mat4  gWorldViewProjMatrix;
uniform mat4  gWorldViewMatrix;

#ifdef DEPTH_PARTICLE
varying float ZDepth;
#endif

void main()
{
   //-- Transform position
   gl_Position = gl_Vertex * gWorldViewProjMatrix;

   //-- pass through values
   gl_TexCoord[0].st = gl_MultiTexCoord0.st;
   gl_TexCoord[1].st = gl_MultiTexCoord1.st;

   //-- modulate our RGB color by the particles HDR intensity
   gl_FrontColor.rgb = gl_Color.rgb * gl_MultiTexCoord2.x;
   gl_FrontColor.a   = gl_Color.a;

#ifdef DEPTH_PARTICLE
   //-- Pass through our zDepth in View space
   vec3 viewSpacePos = gl_Vertex * gWorldViewMatrix;
   ZDepth = viewSpacePos.z;
#endif 
}


//------------------------
// FUNCTION_PS ParticlePS

uniform sampler2D gSampler0;
uniform float gRGBScale;

#ifdef DEPTH_PARTICLE
uniform sampler2D gSampler1;
uniform float gZOffsetScale;
varying float ZDepth;
#endif

void main()
{
   vec4 textureSample0 = SRGBToLinear(texture2D(gSampler0, gl_TexCoord[0].st));
   gl_FragColor = textureSample0 * gl_Color;

#ifdef DEPTH_PARTICLE
/*  KLC  Don't think this is used.
   //-- look up our zOffset Texture Sample
   //-- bring our texture sample into -0.5f to 0.5f range
   vec4 zOffsetTextureSample = texture2D(gSampler1, gl_TexCoord[0].st) - 0.5;

   //-- View depth
   //-- V = Z + (TextureSample * zOffsetScale)
   float viewDepth = max(0.0, ZDepth + (-zOffsetTextureSample * gZOffsetScale));
   //-- outdepth
   //-- oDepth = (V * Q + R) / V
   //-- where Q = matrix._m22
   //-- where R = matrix._m32	
   gl_FragDepth = max(0.0, ((viewDepth * gProjMatrix._m22) + gProjMatrix._m32) / viewDepth);
*/
#endif 

   gl_FragColor.rgb *= gRGBScale;
}